class RelevanceFilter:
    def __init__(self, cfg, api_client):
        self.cfg = cfg
        self.api_client = api_client
        self.threshold = cfg.get("relevance_threshold", 3.0)

    async def get_relevance(self, triple, initial_query):
        entity, rel, obj = triple
        prompt = f"""
        Rate the relevance of the following triple to the query on a scale of 0 to 10.
        Query: "{initial_query}"
        Triple: ("{entity}", "{rel}", "{obj}")
        Reply with a number only.
        """
        response = await self.api_client.call("gpt-4o-mini-2024-07-18", prompt, for_graph=True)
        try:
            return float(response.strip())
        except ValueError:
            return 0.0

    async def filter_triples(self, triples, initial_query):
        tasks = [self.get_relevance(triple, initial_query) for triple in triples]
        scores = await asyncio.gather(*tasks)
        return [triple for triple, score in zip(triples, scores) if score >= self.threshold]
